<?php

namespace Automattic\WooCommerce\Blocks\Payments\Integrations;

use Automattic\WooCommerce\Blocks\Assets\Api;

/**
 * Webxpay payment method integration
 */
final class WebXPay extends AbstractPaymentMethodType {
	/**
	 * Payment method name defined by payment methods extending this class.
	 *
	 * @var string
	 */
	protected $name = 'webxpay';
	public $settings;
	public function __construct() {
	}

	 public function initialize() {
	 	$this->settings = get_option( 'woocommerce_webxpay_settings', array() );
	}

    public function is_active() {
	    return ! empty( $this->settings['enabled'] ) && 'yes' === $this->settings['enabled'];
    }
    public function get_payment_method_script_handles() {
		 $version      = '5.4';
		wp_register_script( 'wc-payment-method-webxpay', plugins_url( 'build/index.js', __FILE__ ), array(), $version.( WP_DEBUG ? '.' . wp_rand( 0, 9999 ) : '' ), true );
		return array( 'wc-payment-method-webxpay' );
    }
    public function get_payment_method_data() {
		$icon         = plugins_url( '/images/webxpay_logo.png', __FILE__ );
	   return [
		  'title'                             => $this->settings['title'],
		  'description'                       => $this->settings['description'],
		  'icon'                              => $icon,
	];
}

}
